// This code, in its entirety, is Copyrighted Terry Smith, 2000.

import java.io.*;
import java.sql.*;
import java.util.Date;
import java.math.BigDecimal;

import Utilities;
import DBConnectionPool;

public class Member
{
   private Long m_MemberID;
   private String m_FirstName;
   private String m_LastName;
   private String m_Email;
   private boolean m_EmailBouncing;
   private String m_Password;
   private java.util.Date m_RegistrationDate;

   /** The default constructor initializes the object
   * attributes as follows:
   * <ul>
   *    <li>MemberID is a newly generated, unique ID.
   *    <li>FirstName, LastName, Email, and Password are set to null.
   *    <li>EmailBouncing is set to false.
   *    <li>RegistrationDate is set to the object's creation date\time.
   * </ul>
   */
   public Member()
   {
      long Now = System.currentTimeMillis();

      m_MemberID = new Long( Now );
      m_FirstName = null;
      m_LastName = null;
      m_Email = null;
      m_EmailBouncing = false;
      m_Password = null;
      m_RegistrationDate = new java.util.Date( Now );
   }

   public Long getMemberID()
   {
      return m_MemberID;
   }

   public void setMemberID( Long MemberID )
   {
      m_MemberID = MemberID;
   }

   public String getFirstName()
   {
      return m_FirstName;
   }

   public void setFirstName( String FirstName )
   {
      m_FirstName = FirstName;
   }

   public String getLastName()
   {
      return m_LastName;
   }

   public void setLastName( String LastName )
   {
      m_LastName = LastName;
   }

   public String getEmail()
   {
      return m_Email;
   }

   public void setEmail( String Email )
   {
      m_Email = Email;
   }

   public boolean isEmailBouncing()
   {
      return m_EmailBouncing;
   }

   public void setEmailBouncing( boolean EmailBouncing )
   {
      m_EmailBouncing = EmailBouncing;
   }

   public String getPassword()
   {
      return m_Password;
   }

   public void setPassword( String Password )
   {
      m_Password = Password;
   }

   public java.util.Date getRegistrationDate()
   {
      return m_RegistrationDate;
   }

   public void setRegistrationDate( java.util.Date RegistrationDate )
   {
      m_RegistrationDate = RegistrationDate;
   }

   public String toString()
   {
      StringBuffer State = new StringBuffer();

      State.append( "\nMemberID \t\t" + m_MemberID );
      State.append( "\nFirstName \t\t" + m_FirstName );
      State.append( "\nLastName \t\t" + m_LastName );
      State.append( "\nEmail \t\t\t" + m_Email );
      State.append( "\nEmailBouncing \t\t" + m_EmailBouncing );
      State.append( "\nPassword \t\t" + m_Password );
      State.append( "\nRegistrationDate \t" + m_RegistrationDate );

      return State.toString();
   }

   public boolean create( StringBuffer ErrorMessages )
   {
      DBConnectionPool dbConnectionPool = DBConnectionPool.getInstance();
      Connection dbConnection = dbConnectionPool.getConnection();

      EasyStatement Statement = new EasyStatement( dbConnection );

      try
      {
         StringBuffer SQL = new StringBuffer();

         SQL.append("Insert into Member (MemberID, FirstName, ");
         SQL.append("LastName, Email, EmailBouncing, Password, ");
         SQL.append("RegistrationDate) ");
         SQL.append("Values (?, ?, ?, ?, ?, ?, ?)");

         Statement.setSQL( SQL.toString() );

         Statement.write( m_MemberID );
         Statement.write( m_FirstName );
         Statement.write( m_LastName );
         Statement.write( m_Email );
         Statement.write( m_EmailBouncing );
         Statement.write( m_Password );
         Statement.write( m_RegistrationDate );

         int Count = Statement.executeUpdate();

         if ( Count == 1 )
         {
            dbConnection.commit();
            return true;
         }
         else
         {
            dbConnection.rollback();
            return false;
         }
      }
      catch( SQLException Exception )
      {
         String Message = Exception.getMessage();
         ErrorMessages.append( Message );
         System.out.println( Message);

         while( (Exception = Exception.getNextException()) != null )
         {
            Message = Exception.getMessage();
            ErrorMessages.append( Message );
            System.out.println( Message );
         }

         try
         {
            dbConnection.rollback();
         }
         catch( SQLException Ignored ) {}

         return false;
      }
      finally
      {
         try
         {
            if ( Statement != null )
               Statement.close();

            dbConnectionPool.free( dbConnection );
         }
         catch( Exception Ignored ) {}
      }
   }

   public boolean findByEmail( String Email )
   {
      DBConnectionPool dbConnectionPool = DBConnectionPool.getInstance();
      Connection dbConnection = dbConnectionPool.getConnection();

      EasyStatement Statement = new EasyStatement( dbConnection );
      EasyResultSet ResultSet = null;

      try
      {
         Statement.setSQL( "Select * from Member where Email = ?" );
         Statement.write( Email );

         ResultSet = Statement.executeQuery();

         boolean FoundRecord = ResultSet.next();

         if ( FoundRecord )
         {
            m_MemberID = ResultSet.readLong();
            m_FirstName = ResultSet.readString();
            m_LastName = ResultSet.readString();
            m_Email = ResultSet.readString();
            m_EmailBouncing = ResultSet.readBoolean();
            m_Password = ResultSet.readString();
            m_RegistrationDate = ResultSet.readDate();

            return true;
         }
         else
         {
            System.out.println("Record not found.");
            return false;
         }
      }
      catch( SQLException Exception )
      {
         String Message = Exception.getMessage();
         System.out.println( Message);

         while( (Exception = Exception.getNextException()) != null )
         {
            Message = Exception.getMessage();
            System.out.println( Message );
         }

         try
         {
            dbConnection.rollback();
         }
         catch( SQLException Ignored ) {}

         return false;
      }
      finally
      {
         try
         {
            if ( Statement != null )
               Statement.close();

            if ( ResultSet != null )
               ResultSet.close();

            dbConnectionPool.free( dbConnection );
         }
         catch( Exception Ignored ) {}
      }
   }

   public boolean update( StringBuffer ErrorMessages )
   {
      DBConnectionPool dbConnectionPool = DBConnectionPool.getInstance();
      Connection dbConnection = dbConnectionPool.getConnection();

      EasyStatement Statement = new EasyStatement( dbConnection );

      try
      {
         StringBuffer SQL = new StringBuffer();

         SQL.append("update Member set FirstName = ?, LastName = ?, Email = ?, ");
         SQL.append("EmailBouncing = ?, Password = ?, RegistrationDate = ? ");
         SQL.append("where MemberID = ?");

         Statement.setSQL( SQL.toString() );

         Statement.write( m_FirstName );
         Statement.write( m_LastName );
         Statement.write( m_Email );
         Statement.write( m_EmailBouncing );
         Statement.write( m_Password );
         Statement.write( m_RegistrationDate );
         Statement.write( m_MemberID );

         int Count = Statement.executeUpdate();

         if ( Count == 1 )
         {
            dbConnection.commit();
            return true;
         }
         else
         {
            dbConnection.rollback();
            return false;
         }
      }
      catch( SQLException Exception )
      {
         String Message = Exception.getMessage();
         ErrorMessages.append( Message );
         System.out.println( Message);

         while( (Exception = Exception.getNextException()) != null )
         {
            Message = Exception.getMessage();
            ErrorMessages.append( Message );
            System.out.println( Message );
         }

         try
         {
            dbConnection.rollback();
         }
         catch( SQLException Ignored ) {}

         return false;
      }
      finally
      {
         try
         {
            if ( Statement != null )
               Statement.close();

            dbConnectionPool.free( dbConnection );
         }
         catch( Exception Ignored ) {}
      }
   }

   public boolean delete( StringBuffer ErrorMessages )
   {
      DBConnectionPool dbConnectionPool = DBConnectionPool.getInstance();
      Connection dbConnection = dbConnectionPool.getConnection();

      EasyStatement Statement = new EasyStatement( dbConnection );

      try
      {
         Statement.setSQL( "delete from Member where MemberID = ?" );
         Statement.write( m_MemberID );

         int Count = Statement.executeUpdate();

         if ( Count == 1 )
         {
            dbConnection.commit();
            return true;
         }
         else
         {
            dbConnection.rollback();
            return false;
         }
      }
      catch( SQLException Exception )
      {
         String Message = Exception.getMessage();
         ErrorMessages.append( Message );
         System.out.println( Message);

         while( (Exception = Exception.getNextException()) != null )
         {
            Message = Exception.getMessage();
            ErrorMessages.append( Message );
            System.out.println( Message );
         }

         try
         {
            dbConnection.rollback();
         }
         catch( SQLException Ignored ) {}

         return false;
      }
      finally
      {
         try
         {
            if ( Statement != null )
               Statement.close();

            dbConnectionPool.free( dbConnection );
         }
         catch( Exception Ignored ) {}
      }
   }
}


